unit DebugTFDD;

interface

implementation

uses
  Windows, SysUtils;

function DebugOpen(var F: TTextRec): Integer; forward;
function DebugOutput(var F: TTextRec): Integer; forward;
function DebugClose(var F: TTextRec): Integer; forward;

procedure AssignDebug(var F: TextFile);
begin
  { Set up text file variable }
  TTextRec(F).Handle := $FFFF;
  TTextRec(F).OpenFunc := @DebugOpen;
  TTextRec(F).Mode := fmClosed;
  TTextRec(F).BufSize := SizeOf(TTextRec(F).Buffer);
  TTextRec(F).BufPtr := @TTextRec(F).Buffer;
  TTextRec(F).Name[0] := #0;
end;

function DebugOpen(var F: TTextRec): Integer;
begin
  Result := 0;
  if F.Mode = fmInput then
  begin
    Result := 5 // Access denied
  end
  else
  begin
    F.Mode := fmOutput;
    F.InOutFunc := @DebugOutput;
    F.FlushFunc := @DebugOutput;
  end;
  F.CloseFunc := @DebugClose;
end;

var
  DebugMsg: String = '';

function DebugOutput(var F: TTextRec): Integer;
var
  Txt: AnsiString;
begin
  Result := 0;
  if F.BufPos > 0 then
  begin
    SetLength(Txt, F.BufPos);
    Move(F.BufPtr^, Txt[1], F.BufPos);
    F.BufPos := 0;
    if Txt = #$D then
    begin
      // Just swallow any lone carriage return characters
    end
    else
    begin
      DebugMsg := DebugMsg + String(Txt);
    end;
    if Txt = #$A then
    begin
      OutputDebugString(PChar(DebugMsg));
      DebugMsg := '';
    end;
  end;
end;

function DebugClose(var F: TTextRec): Integer;
begin
  Result := 0;
end;

initialization
  // If you are working with a console application, then you may
  // prefer to pass a different TextFile variable into AssignDebug
  AssignDebug(Output);
  Rewrite(Output);
end.
